﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.ModelsEnumTypes;
using PpmsDataWebService.Models;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class ProviderContactsMap
    {
        public static async Task<IQueryable<ProviderContact>> MapProviderContacts(List<Contact> ppmsProviderContacts, string mapRelatedType, PpmsContext context)
        {
            var providerContacts = new List<ProviderContact> {};
            foreach (var ppmsProviderContact in ppmsProviderContacts)
            {
                //Contact Info
                var providerContact = new ProviderContact { };

                providerContact.FullName = ppmsProviderContact.FullName;
                
                if(ppmsProviderContact.AccountRoleCode != null)
                {
                    switch (ppmsProviderContact.AccountRoleCode.Value)
                    {
                        case (int)Contact_AccountRoleCode.CIO:
                            providerContact.ContactRole = ContactRole.CIO;
                            break;
                        case (int)Contact_AccountRoleCode.CMIO:
                            providerContact.ContactRole = ContactRole.CMIO;
                            break;
                        case (int)Contact_AccountRoleCode.COO:
                            providerContact.ContactRole = ContactRole.COO;
                            break;
                        case (int)Contact_AccountRoleCode.General:
                            providerContact.ContactRole = ContactRole.General;
                            break;
                        case (int)Contact_AccountRoleCode.Other:
                            providerContact.ContactRole = ContactRole.Other;
                            break;
                    }
                }


                if (ppmsProviderContact.ParentCustomerId != null)
                {
                    providerContact.CompanyName = ppmsProviderContact.ParentCustomerId.Name;
                    //var ppmsCompany = context.AccountSet.First(i => i.Id == ppmsProviderContact.ParentCustomerId.Id);
                    // var ppmsCompanyList = new List<Account> { ppmsCompany };
                    //providerContact.Company = await ProviderMap.MapProviders(ppmsCompanyList, "None", context);
                }

                if (ppmsProviderContact.ppms_isveteran != null)
                    switch (ppmsProviderContact.ppms_isveteran.Value)
                    {
                        case true:
                            providerContact.IsVeteran = true;
                            break;
                        case false:
                            providerContact.IsVeteran = false;
                            break;
                    }

                providerContact.EmergencyResponderIndicator = ppmsProviderContact.ppms_emergencyresponderindicator;

                if (ppmsProviderContact.ppms_isotherpartycontact != null)
                    switch (ppmsProviderContact.ppms_isotherpartycontact.Value)
                    {
                        case true:
                            providerContact.IsOtherPartyContact = true;
                            break;
                        case false:
                            providerContact.IsOtherPartyContact = false;
                            break;
                    }

                if (ppmsProviderContact.ParentCustomerId != null)
                {
                    providerContact.ProviderName = ppmsProviderContact.ParentCustomerId.Name;
                }

                providerContact.BusinessPhone = ppmsProviderContact.Telephone1;
                providerContact.MobilePhone = ppmsProviderContact.MobilePhone;
                providerContact.Fax = ppmsProviderContact.Fax;
                providerContact.Email = ppmsProviderContact.EMailAddress1;

                if (ppmsProviderContact.PreferredContactMethodCode != null)
                    switch (ppmsProviderContact.PreferredContactMethodCode.Value)
                    {
                        case (int)Account_PreferredContactMethodCode.Email:
                            providerContact.PreferredMethodOfContact = PreferredMethodOfContact.Email;
                            break;
                        case (int)Account_PreferredContactMethodCode.Any:
                            providerContact.PreferredMethodOfContact = PreferredMethodOfContact.Any;
                            break;
                        case (int)Account_PreferredContactMethodCode.Fax:
                            providerContact.PreferredMethodOfContact = PreferredMethodOfContact.Fax;
                            break;
                        case (int)Account_PreferredContactMethodCode.Mail:
                            providerContact.PreferredMethodOfContact = PreferredMethodOfContact.Mail;
                            break;
                        case (int)Account_PreferredContactMethodCode.Phone:
                            providerContact.PreferredMethodOfContact = PreferredMethodOfContact.Phone;
                            break;
                    }

                if (ppmsProviderContact.ppms_deliverystatus != null)
                    switch (ppmsProviderContact.ppms_deliverystatus.Value)
                    {
                        case (int)Contact_ppms_deliverystatus.Noproblemshaveoccurred:
                            providerContact.DeliveryStatus = DeliveryStatus.NoProblemsHaveOccurred;
                            break;
                        case (int)Contact_ppms_deliverystatus.Rejectedasinvalid:
                            providerContact.DeliveryStatus = DeliveryStatus.RejectedAsInvalid;
                            break;                  
                    }

                //Address
                providerContact.Address = ppmsProviderContact.Address1_Composite;
                //AddressCity = ppmsProviderContact.Address1_City,
                //AddressCountryRegion = ppmsProviderContact.Address1_Country,
                //AddressState = ppmsProviderContact.Address1_StateOrProvince,
                //AddressStreet1 = ppmsProviderContact.Address1_Line1,
                //AddressStreet2 = ppmsProviderContact.Address1_Line2,
                //AddressZip = ppmsProviderContact.Address1_PostalCode,

                if (ppmsProviderContact.ppms_isaddessactive != null)
                    switch (ppmsProviderContact.ppms_isaddessactive.Value)
                    {
                        case true:
                            providerContact.IsAddressActive = true;
                            break;
                        case false:
                            providerContact.IsAddressActive = false;
                            break;
                    }

                if (ppmsProviderContact.ppms_ismailingaddress != null)
                    switch (ppmsProviderContact.ppms_ismailingaddress.Value)
                    {
                        case true:
                            providerContact.IsMailingAddress = true;
                            break;
                        case false:
                            providerContact.IsMailingAddress = false;
                            break;
                    }

                if (ppmsProviderContact.ppms_addressinvalidreason != null)
                    switch (ppmsProviderContact.ppms_addressinvalidreason.Value)
                    {
                        case (int)Contact_ppms_addressinvalidreason.AddressDoesNotExist:
                            providerContact.AddressInvalidReason = AddressInvalidReason.AddressDoesNotExist;
                            break;
                        case (int)Contact_ppms_addressinvalidreason.Death:
                            providerContact.AddressInvalidReason = AddressInvalidReason.Death;
                            break;
                        case (int)Contact_ppms_addressinvalidreason.MissingRequiredAddressField:
                            providerContact.AddressInvalidReason = AddressInvalidReason.MissingRequiredAddressField;
                            break;
                        case (int)Contact_ppms_addressinvalidreason.Other:
                            providerContact.AddressInvalidReason = AddressInvalidReason.Other;
                            break;
                        case (int)Contact_ppms_addressinvalidreason.VeteranDoesNotResideatAddress:
                            providerContact.AddressInvalidReason = AddressInvalidReason.VeteranDoesNotResideAtAddress;
                            break;
                    }

                //Personal Details
                if (ppmsProviderContact.GenderCode != null)
                    switch (ppmsProviderContact.GenderCode.Value)
                    {
                        case (int)Contact_GenderCode.Male:
                            providerContact.Gender = Gender.Male;
                            break;
                        case (int)Contact_GenderCode.Female:
                            providerContact.Gender = Gender.Female;
                            break;
                        default:
                            providerContact.Gender = Gender.NotSpecified;
                            break;
                    }

                if (ppmsProviderContact.FamilyStatusCode != null)
                    switch (ppmsProviderContact.FamilyStatusCode.Value)
                    {
                        case (int)Contact_FamilyStatusCode.Single:
                            providerContact.MaritalStatus = MaritalStatus.Single;
                            break;
                        case (int)Contact_FamilyStatusCode.Divorced:
                            providerContact.MaritalStatus = MaritalStatus.Divorced;
                            break;
                        case (int)Contact_FamilyStatusCode.Married:
                            providerContact.MaritalStatus = MaritalStatus.Married;
                            break;
                        case (int)Contact_FamilyStatusCode.Widowed:
                            providerContact.MaritalStatus = MaritalStatus.Widowed;
                            break;
                    }

                providerContact.SpousePartnerName = ppmsProviderContact.SpousesName;

                if (ppmsProviderContact.BirthDate != null)
                {
                    providerContact.Birthday = ppmsProviderContact.BirthDate.ToString();}

                if (ppmsProviderContact.Anniversary != null)
                {
                    providerContact.Anniversary = ppmsProviderContact.Anniversary.ToString();
                }
                if (ppmsProviderContact.ppms_dateofdeath != null)
                {
                    providerContact.DateOfDeath = ppmsProviderContact.ppms_dateofdeath.ToString();
                }
                providerContact.PersonalNotes = ppmsProviderContact.Description;

                //Contact Preferences
                //Allow Email? 
                    switch (providerContact.AllowEmail)
                    {
                        case true:
                            providerContact.AllowEmail = true;
                            break;
                        case false:
                            providerContact.AllowEmail = false;
                            break;
                    }

                //Allow Follow Email? 
                switch (providerContact.AllowFollowEmail)
                {
                    case true:
                        providerContact.AllowFollowEmail = true;
                        break;
                    case false:
                        providerContact.AllowFollowEmail = false;
                        break;
                }

                //Allow Bulk Email? 
                switch (providerContact.AllowBulkEmail)
                {
                    case true:
                        providerContact.AllowBulkEmail = true;
                        break;
                    case false:
                        providerContact.AllowBulkEmail = false;
                        break;
                }

                //Allow Phone? 
                switch (providerContact.AllowPhone)
                {
                    case true:
                        providerContact.AllowPhone = true;
                        break;
                    case false:
                        providerContact.AllowPhone = false;
                        break;
                }

                //Allow Fax? 
                switch (providerContact.AllowFax)
                {
                    case true:
                        providerContact.AllowFax = true;
                        break;
                    case false:
                        providerContact.AllowFax = false;
                        break;
                }

                //Allow Mail? 
                switch (providerContact.AllowMail)
                {
                    case true:
                        providerContact.AllowMail = true;
                        break;
                    case false:
                        providerContact.AllowMail = false;
                        break;
                }

                //Other
                //Texting allowed?
                switch (providerContact.IsTextingAcceptable)
                {
                    case true:
                        providerContact.IsTextingAcceptable = true;
                        break;
                    case false:
                        providerContact.IsTextingAcceptable = false;
                        break;
                }

                if (mapRelatedType.Contains("?$expand=Provider"))
                    mapRelatedType = "Provider";
                if (mapRelatedType.Contains("?$expand=CareSites"))
                    mapRelatedType = "CareSites";

                //Related Type Switch
                switch (mapRelatedType)
                {
                    case "Provider":
                        //Lookup and Map the Provider 
                        var ppmsProviders =
                            context.AccountSet.Where(i => i.Id == ppmsProviderContact.ParentCustomerId.Id);
                        var ppmsProvidersList = ppmsProviders.ToList();
                        providerContact.Provider =
                            await ProviderMap.MapProviders(ppmsProvidersList, "None");
                        break;
                    case "CareSites":
                        //Lookup and Map the Care Sites
                        var ppmsCareSites =
                            context.ppms_caresiteSet.Where(i => i.ppms_SiteContact.Id == ppmsProviderContact.Id);
                        var ppmsCareSitesList = ppmsCareSites.ToList();
                        providerContact.CareSites =
                            await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                        break;
                    default:
                        break;
                }



                providerContacts.Add(providerContact);               
            }
            return providerContacts.AsQueryable();            
        }
    }
}